<?php
require_once __DIR__ . '/../config/config.php';

if (!isLoggedIn() || !isStaff()) {
    setFlashMessage('error', 'Access denied.');
    redirect('/auth/login.php');
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $complaintId = intval($_POST['complaint_id'] ?? 0);
    $userId = getCurrentUserId();

    if ($complaintId) {
        $db = getDB();
        
        // Assign to self
        $stmt = $db->prepare("UPDATE complaints SET assigned_to = ?, status = 'in_progress' WHERE id = ? AND assigned_to IS NULL");
        $stmt->execute([$userId, $complaintId]);

        if ($stmt->rowCount() > 0) {
            // Log activity
            $logStmt = $db->prepare("INSERT INTO activity_logs (complaint_id, user_id, action, details) VALUES (?, ?, ?, ?)");
            $logStmt->execute([$complaintId, $userId, 'assigned', 'Complaint self-assigned']);

            setFlashMessage('success', 'Complaint assigned to you successfully.');
        } else {
            setFlashMessage('error', 'Could not assign complaint. It may already be assigned.');
        }
    }
}

redirect('/staff/dashboard.php');
