<?php
require_once __DIR__ . '/../config/config.php';

if (!isCustomerLoggedIn()) {
    redirect('/');
}

$db = getDB();
$userId = getCurrentUserId();

// Get customer stats
$stats = [];

// Total complaints
$stmt = $db->prepare("SELECT COUNT(*) as total FROM complaints WHERE customer_id = ?");
$stmt->execute([$userId]);
$stats['total'] = $stmt->fetch()['total'];

// Open complaints
$stmt = $db->prepare("SELECT COUNT(*) as total FROM complaints WHERE customer_id = ? AND status IN ('open', 'in_progress', 'pending_customer')");
$stmt->execute([$userId]);
$stats['open'] = $stmt->fetch()['total'];

// Resolved complaints
$stmt = $db->prepare("SELECT COUNT(*) as total FROM complaints WHERE customer_id = ? AND status IN ('resolved', 'closed')");
$stmt->execute([$userId]);
$stats['resolved'] = $stmt->fetch()['total'];

// Recent complaints with new schema
$stmt = $db->prepare("
    SELECT c.*, o.order_number, i.title as issue_title, d.name as department_name, b.name as branch_name
    FROM complaints c
    JOIN orders o ON c.order_id = o.id
    JOIN branches b ON c.branch_id = b.id
    LEFT JOIN complaint_issues i ON c.issue_id = i.id
    LEFT JOIN departments d ON c.department_id = d.id
    WHERE c.customer_id = ?
    ORDER BY c.created_at DESC
    LIMIT 5
");
$stmt->execute([$userId]);
$recentComplaints = $stmt->fetchAll();

$pageTitle = 'My Dashboard - Support Center';
require_once __DIR__ . '/../includes/header.php';
?>

<div class="mb-8">
    <h1 class="text-3xl font-bold text-gray-800">Welcome!</h1>
    <p class="text-gray-500 mt-1">
        <i class="fab fa-whatsapp text-green-500 mr-1"></i>
        <?= sanitize($_SESSION['whatsapp_number'] ?? '') ?>
        <?php if (!empty($_SESSION['user_email'])): ?>
        <span class="mx-2">•</span>
        <i class="fas fa-envelope text-gray-400 mr-1"></i>
        <?= sanitize($_SESSION['user_email']) ?>
        <?php endif; ?>
    </p>
</div>

<!-- Stats Cards -->
<div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-6 mb-8">
    <div class="bg-white rounded-xl shadow-lg p-6 border-l-4 border-blue-500">
        <div class="flex items-center justify-between">
            <div>
                <p class="text-sm text-gray-500">Total Complaints</p>
                <p class="text-3xl font-bold text-gray-800"><?= $stats['total'] ?></p>
            </div>
            <div class="w-12 h-12 bg-blue-100 rounded-full flex items-center justify-center">
                <i class="fas fa-ticket-alt text-blue-500 text-xl"></i>
            </div>
        </div>
    </div>

    <div class="bg-white rounded-xl shadow-lg p-6 border-l-4 border-yellow-500">
        <div class="flex items-center justify-between">
            <div>
                <p class="text-sm text-gray-500">Open Complaints</p>
                <p class="text-3xl font-bold text-gray-800"><?= $stats['open'] ?></p>
            </div>
            <div class="w-12 h-12 bg-yellow-100 rounded-full flex items-center justify-center">
                <i class="fas fa-clock text-yellow-500 text-xl"></i>
            </div>
        </div>
    </div>

    <div class="bg-white rounded-xl shadow-lg p-6 border-l-4 border-green-500">
        <div class="flex items-center justify-between">
            <div>
                <p class="text-sm text-gray-500">Resolved</p>
                <p class="text-3xl font-bold text-gray-800"><?= $stats['resolved'] ?></p>
            </div>
            <div class="w-12 h-12 bg-green-100 rounded-full flex items-center justify-center">
                <i class="fas fa-check-circle text-green-500 text-xl"></i>
            </div>
        </div>
    </div>

</div>

<div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
    <!-- Recent Complaints -->
    <div class="bg-white rounded-xl shadow-lg p-6">
        <div class="flex items-center justify-between mb-6">
            <h2 class="text-lg font-semibold text-gray-800">Recent Complaints</h2>
            <a href="<?= BASE_URL ?>/customer/complaints.php" class="text-primary hover:underline text-sm">View All</a>
        </div>

        <?php if (empty($recentComplaints)): ?>
        <div class="text-center py-8 text-gray-500">
            <i class="fas fa-inbox text-4xl mb-3"></i>
            <p>No complaints yet</p>
        </div>
        <?php else: ?>
        <div class="space-y-4">
            <?php foreach ($recentComplaints as $complaint): ?>
            <a href="<?= BASE_URL ?>/complaint/view.php?ticket=<?= sanitize($complaint['ticket_number']) ?>" 
               class="block p-4 bg-gray-50 rounded-lg hover:bg-gray-100 transition">
                <div class="flex items-start justify-between">
                    <div class="flex-1">
                        <div class="flex items-center gap-2 mb-1">
                            <span class="px-2 py-0.5 rounded-full text-xs font-medium <?= getStatusBadgeClass($complaint['status']) ?>">
                                <?= ucfirst(str_replace('_', ' ', $complaint['status'])) ?>
                            </span>
                            <span class="text-xs text-gray-500"><?= sanitize($complaint['ticket_number']) ?></span>
                        </div>
                        <p class="font-medium text-gray-800 line-clamp-1"><?= sanitize($complaint['issue_title'] ?? 'Complaint') ?></p>
                        <p class="text-sm text-gray-500 mt-1">
                            <i class="fas fa-store text-xs mr-1"></i><?= sanitize($complaint['branch_name']) ?> • <?= formatDate($complaint['created_at']) ?>
                        </p>
                    </div>
                    <i class="fas fa-chevron-right text-gray-400"></i>
                </div>
            </a>
            <?php endforeach; ?>
        </div>
        <?php endif; ?>
    </div>

    <!-- How to Submit New Complaint -->
    <div class="bg-white rounded-xl shadow-lg p-6">
        <h2 class="text-lg font-semibold text-gray-800 mb-4">Submit a New Complaint</h2>
        <div class="bg-blue-50 rounded-lg p-4">
            <div class="flex items-start gap-4">
                <div class="w-12 h-12 bg-blue-100 rounded-full flex items-center justify-center flex-shrink-0">
                    <i class="fas fa-qrcode text-blue-500 text-xl"></i>
                </div>
                <div>
                    <p class="font-medium text-gray-800">Scan QR Code on Your Invoice</p>
                    <p class="text-sm text-gray-600 mt-1">
                        To submit a new complaint, scan the QR code printed on your invoice. 
                        This will automatically link your complaint to the correct order and branch.
                    </p>
                </div>
            </div>
        </div>
    </div>
</div>


<?php require_once __DIR__ . '/../includes/footer.php'; ?>
