<?php
session_start();

define('BASE_URL', '/kw_crm/CascadeProjects/windsurf-project');
define('UPLOAD_PATH', __DIR__ . '/../uploads/');

require_once __DIR__ . '/database.php';
require_once __DIR__ . '/whatsapp.php';

// Helper functions
function redirect($path) {
    header("Location: " . BASE_URL . $path);
    exit;
}

function isLoggedIn() {
    return isset($_SESSION['user_id']);
}

function isCustomerLoggedIn() {
    return isLoggedIn() && isset($_SESSION['role']) && $_SESSION['role'] === 'customer';
}

function isAdmin() {
    return isset($_SESSION['role']) && $_SESSION['role'] === 'admin';
}

function isBranchManager() {
    return isset($_SESSION['role']) && $_SESSION['role'] === 'branch_manager';
}

function isStaff() {
    return isset($_SESSION['role']) && in_array($_SESSION['role'], ['staff', 'branch_manager', 'admin']);
}

function isCustomer() {
    return isset($_SESSION['role']) && $_SESSION['role'] === 'customer';
}

function getCurrentUserBranchId() {
    return $_SESSION['branch_id'] ?? null;
}

function getCurrentUserId() {
    return $_SESSION['user_id'] ?? null;
}

function getCurrentUserRole() {
    return $_SESSION['role'] ?? null;
}

function loginCustomer($customer) {
    $_SESSION['user_id'] = $customer['id'];
    $_SESSION['user_name'] = $customer['full_name'] ?? 'Customer';
    $_SESSION['user_email'] = $customer['email'];
    $_SESSION['whatsapp_number'] = $customer['whatsapp_number'];
    $_SESSION['role'] = 'customer';
    $_SESSION['is_verified'] = true;
}

function logoutCustomer() {
    unset($_SESSION['user_id']);
    unset($_SESSION['user_name']);
    unset($_SESSION['user_email']);
    unset($_SESSION['whatsapp_number']);
    unset($_SESSION['role']);
    unset($_SESSION['is_verified']);
}

function sanitize($input) {
    return htmlspecialchars(trim($input), ENT_QUOTES, 'UTF-8');
}

function generateTicketNumber() {
    return 'TKT-' . date('Ymd') . '-' . strtoupper(substr(uniqid(), -6));
}

function generateAccessToken() {
    return bin2hex(random_bytes(32));
}

function getBranchManager($db, $branchId) {
    $stmt = $db->prepare("SELECT * FROM users WHERE branch_id = ? AND role = 'branch_manager' AND is_active = 1 LIMIT 1");
    $stmt->execute([$branchId]);
    return $stmt->fetch();
}

function logWhatsAppMessage($db, $complaintId, $recipientNumber, $messageType, $messageContent, $sentBy = null, $isSent = false) {
    $stmt = $db->prepare("
        INSERT INTO whatsapp_messages (complaint_id, recipient_number, message_type, message_content, sent_by, is_sent, sent_at)
        VALUES (?, ?, ?, ?, ?, ?, ?)
    ");
    $stmt->execute([
        $complaintId,
        $recipientNumber,
        $messageType,
        $messageContent,
        $sentBy,
        $isSent ? 1 : 0,
        $isSent ? date('Y-m-d H:i:s') : null
    ]);
    return $db->lastInsertId();
}

function formatDate($date) {
    return date('M d, Y h:i A', strtotime($date));
}

function getStatusBadgeClass($status) {
    $classes = [
        'open' => 'bg-blue-100 text-blue-800',
        'in_progress' => 'bg-yellow-100 text-yellow-800',
        'pending_customer' => 'bg-purple-100 text-purple-800',
        'resolved' => 'bg-green-100 text-green-800',
        'closed' => 'bg-gray-100 text-gray-800'
    ];
    return $classes[$status] ?? 'bg-gray-100 text-gray-800';
}

function getPriorityBadgeClass($priority) {
    $classes = [
        'low' => 'bg-gray-100 text-gray-800',
        'medium' => 'bg-blue-100 text-blue-800',
        'high' => 'bg-orange-100 text-orange-800',
        'urgent' => 'bg-red-100 text-red-800'
    ];
    return $classes[$priority] ?? 'bg-gray-100 text-gray-800';
}

function setFlashMessage($type, $message) {
    $_SESSION['flash'] = ['type' => $type, 'message' => $message];
}

function getFlashMessage() {
    if (isset($_SESSION['flash'])) {
        $flash = $_SESSION['flash'];
        unset($_SESSION['flash']);
        return $flash;
    }
    return null;
}
