<?php
/**
 * Verify OTP API
 * 
 * Verifies the OTP and creates/logs in the customer
 */

require_once __DIR__ . '/../config/config.php';

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'error' => 'Method not allowed']);
    exit;
}

$input = json_decode(file_get_contents('php://input'), true);
$whatsappNumber = $input['whatsapp_number'] ?? $_POST['whatsapp_number'] ?? '';
$otpCode = $input['otp_code'] ?? $_POST['otp_code'] ?? '';
$email = $input['email'] ?? $_POST['email'] ?? '';

if (empty($whatsappNumber) || empty($otpCode)) {
    http_response_code(400);
    echo json_encode(['success' => false, 'error' => 'WhatsApp number and OTP are required']);
    exit;
}

// Validate email if provided
if (!empty($email) && !filter_var($email, FILTER_VALIDATE_EMAIL)) {
    http_response_code(400);
    echo json_encode(['success' => false, 'error' => 'Invalid email format']);
    exit;
}

$db = getDB();

// Verify OTP
$result = WhatsAppOTP::verifyOTP($db, $whatsappNumber, $otpCode);

if (!$result['success']) {
    http_response_code(400);
    echo json_encode(['success' => false, 'error' => $result['error']]);
    exit;
}

// Get or create customer
$customer = WhatsAppOTP::getOrCreateCustomer($db, $whatsappNumber, $email);

// Log in the customer
loginCustomer($customer);

echo json_encode([
    'success' => true,
    'message' => 'Verification successful',
    'customer' => [
        'id' => $customer['id'],
        'whatsapp_number' => $customer['whatsapp_number'],
        'email' => $customer['email'],
        'is_new' => !isset($customer['created_at']) || (time() - strtotime($customer['created_at'] ?? 'now')) < 60
    ]
]);
