<?php
/**
 * Debug Script: Check Customer WhatsApp Number
 * 
 * Usage: http://localhost/kw_crm/CascadeProjects/windsurf-project/api/check-customer.php?phone=923126500234
 */

require_once __DIR__ . '/../config/config.php';

$phone = $_GET['phone'] ?? '';

if (empty($phone)) {
    echo "<h2>Customer WhatsApp Number Checker</h2>";
    echo "<p>Add ?phone=NUMBER to the URL to check</p>";
    echo "<p>Example: ?phone=923126500234</p>";
    exit;
}

$db = getDB();

// Clean the phone number
$cleanPhone = preg_replace('/[^0-9+]/', '', $phone);

echo "<h2>Checking WhatsApp Number: $cleanPhone</h2>";
echo "<hr>";

// Try exact match
echo "<h3>1. Exact Match</h3>";
$stmt = $db->prepare("SELECT id, full_name, whatsapp_number, role FROM users WHERE whatsapp_number = ?");
$stmt->execute([$cleanPhone]);
$result = $stmt->fetch();
if ($result) {
    echo "<pre>✅ FOUND: " . print_r($result, true) . "</pre>";
} else {
    echo "<p>❌ Not found with exact match: $cleanPhone</p>";
}

// Try with + prefix
echo "<h3>2. With + Prefix</h3>";
$withPlus = '+' . $cleanPhone;
$stmt->execute([$withPlus]);
$result = $stmt->fetch();
if ($result) {
    echo "<pre>✅ FOUND: " . print_r($result, true) . "</pre>";
} else {
    echo "<p>❌ Not found with +: $withPlus</p>";
}

// Try without + prefix
echo "<h3>3. Without + Prefix</h3>";
$withoutPlus = ltrim($cleanPhone, '+');
$stmt->execute([$withoutPlus]);
$result = $stmt->fetch();
if ($result) {
    echo "<pre>✅ FOUND: " . print_r($result, true) . "</pre>";
} else {
    echo "<p>❌ Not found without +: $withoutPlus</p>";
}

// Try last 10 digits
echo "<h3>4. Last 10 Digits Match</h3>";
$last10 = substr($cleanPhone, -10);
$stmt = $db->prepare("SELECT id, full_name, whatsapp_number, role FROM users WHERE whatsapp_number LIKE ?");
$stmt->execute(['%' . $last10]);
$result = $stmt->fetch();
if ($result) {
    echo "<pre>✅ FOUND: " . print_r($result, true) . "</pre>";
} else {
    echo "<p>❌ Not found with last 10 digits: $last10</p>";
}

// Show all customers
echo "<hr>";
echo "<h3>All Customers in Database</h3>";
$stmt = $db->query("SELECT id, full_name, whatsapp_number, role FROM users WHERE role = 'customer' ORDER BY id DESC LIMIT 10");
$customers = $stmt->fetchAll();
echo "<table border='1' cellpadding='5'>";
echo "<tr><th>ID</th><th>Name</th><th>WhatsApp Number</th><th>Role</th></tr>";
foreach ($customers as $customer) {
    echo "<tr>";
    echo "<td>{$customer['id']}</td>";
    echo "<td>{$customer['full_name']}</td>";
    echo "<td><strong>{$customer['whatsapp_number']}</strong></td>";
    echo "<td>{$customer['role']}</td>";
    echo "</tr>";
}
echo "</table>";

// Show recent complaints
echo "<hr>";
echo "<h3>Recent Open Complaints</h3>";
$stmt = $db->query("
    SELECT c.id, c.ticket_number, c.customer_id, u.full_name, u.whatsapp_number, c.status, c.created_at
    FROM complaints c
    JOIN users u ON c.customer_id = u.id
    WHERE c.status != 'closed'
    ORDER BY c.created_at DESC
    LIMIT 10
");
$complaints = $stmt->fetchAll();
echo "<table border='1' cellpadding='5'>";
echo "<tr><th>Ticket</th><th>Customer</th><th>WhatsApp</th><th>Status</th><th>Created</th></tr>";
foreach ($complaints as $complaint) {
    echo "<tr>";
    echo "<td>{$complaint['ticket_number']}</td>";
    echo "<td>{$complaint['full_name']}</td>";
    echo "<td><strong>{$complaint['whatsapp_number']}</strong></td>";
    echo "<td>{$complaint['status']}</td>";
    echo "<td>{$complaint['created_at']}</td>";
    echo "</tr>";
}
echo "</table>";
