# Customer Feedback and Complaint Management System

A comprehensive web-based system for managing customer feedback and complaints, built with PHP, MySQL, and Tailwind CSS.

## Features

- **QR Code Based Complaint Submission**: Customers scan QR code on invoice to submit complaints (order + branch in URL)
- **WhatsApp OTP Verification**: Customers verify via WhatsApp OTP - no traditional login/register required
- **Branch-Based Tracking**: Each complaint is linked to a specific branch for better management
- **Detailed Issue Selection**: Single dropdown with comprehensive issue descriptions (replaces category + subject)
- **Role-Based Access Control**: Three user roles (Admin, Staff, Customer) with different permissions
- **Department Routing**: Complaints are automatically routed to relevant departments based on issue type
- **Secure Closure Policy**: Only the complaint owner (customer) or admin can close a complaint
- **Responsive Design**: Modern, mobile-friendly UI built with Tailwind CSS
- **Activity Logging**: Complete audit trail of all actions on complaints
- **File Attachments**: Support for uploading documents and images
- **Export Functionality**: Export complaints to CSV for reporting

## Customer Flow

1. Customer receives invoice with QR code
2. Scans QR code → Opens complaint form with order & branch pre-filled
3. Enters WhatsApp number and email (optional)
4. **If existing customer**: Logged in directly (no OTP needed)
5. **If new customer**: Receives OTP on WhatsApp → Verifies
6. Selects issue from detailed list
7. Submits complaint → Redirected to dashboard
8. Can track and respond to complaints using same WhatsApp number

## User Roles

### Customer (via WhatsApp verification)
- Submit complaints by scanning QR code on invoice
- View and track their complaints
- Respond to staff messages
- Close their own complaints

### Staff (traditional login)
- View complaints assigned to them
- Respond to customers
- Update complaint status and priority
- Self-assign unassigned department complaints

### Admin (traditional login)
- Full access to all complaints
- Assign complaints to staff
- Route complaints to departments
- Manage users and roles
- Close any complaint
- Export data

## Installation

### Requirements
- PHP 7.4 or higher (with cURL extension for WhatsApp API)
- MySQL 5.7 or higher
- Apache with mod_rewrite (XAMPP recommended)
- UltraMsg account for WhatsApp OTP (or similar WhatsApp API)

### Setup Steps

1. **Clone/Copy the project** to your web server directory:
   ```
   c:\xampp\htdocs\kw_crm\CascadeProjects\windsurf-project\
   ```

2. **Create the database**:
   - Open phpMyAdmin or MySQL CLI
   - Run the SQL script in `database/schema.sql`

3. **Setup WhatsApp Service (Baileys)**:
   ```bash
   cd whatsapp-service
   npm install
   npm start
   ```
   - Scan the QR code with WhatsApp on your phone
   - Service runs on http://localhost:3001

4. **Configure database connection**:
   - Edit `config/database.php` if needed
   - Default settings: localhost, root, no password

5. **Access the application**:
   ```
   http://localhost/kw_crm/CascadeProjects/windsurf-project/
   ```

## Demo Accounts

### Admin/Staff (use traditional login at /auth/login.php)
| Role     | Email               | Password |
|----------|---------------------|----------|
| Admin    | admin@company.com   | password |
| Staff    | support@company.com | password |

### Customers (verified via WhatsApp)
| WhatsApp Number | Email            |
|-----------------|------------------|
| +15551234567    | john@example.com |
| +15559876543    | jane@example.com |

## Usage

### Submitting a Complaint (QR Code URL)

Complaints are submitted via QR code URL containing order number AND branch ID:
```
http://localhost/kw_crm/CascadeProjects/windsurf-project/complaint/submit.php?order=ORD-2024-001&branch=1
```

This URL should be encoded in a QR code printed on customer invoices.

### Sample Test URLs
- `?order=ORD-2024-001&branch=1` (Main Branch)
- `?order=ORD-2024-002&branch=2` (North Branch)
- `?order=ORD-2024-003&branch=1` (Main Branch)
- `?order=ORD-2024-004&branch=3` (South Branch)
- `?order=ORD-2024-005&branch=4` (East Mall Outlet)
- `?order=ORD-2024-006&branch=5` (West Plaza Store)

### Development Mode

When WhatsApp service is not running or not connected, the system runs in DEV MODE:
- OTP is displayed on screen for testing
- No actual WhatsApp message is sent
- Existing customers are logged in directly without OTP

## Project Structure

```
windsurf-project/
├── admin/                 # Admin panel pages
│   ├── dashboard.php
│   ├── complaints.php
│   ├── complaint-detail.php
│   ├── users.php
│   └── export.php
├── api/                   # REST API endpoints
│   ├── get_order.php      # Get order details (order + branch)
│   ├── send_otp.php       # Send OTP to WhatsApp
│   └── verify_otp.php     # Verify OTP and login customer
├── auth/                  # Authentication (admin/staff only)
│   ├── login.php
│   └── logout.php
├── complaint/             # Complaint management
│   ├── submit.php         # Multi-step: verify WhatsApp -> select issue -> submit
│   └── view.php
├── config/                # Configuration files
│   ├── config.php
│   ├── database.php
│   └── whatsapp.php       # WhatsApp OTP service (UltraMsg API)
├── customer/              # Customer dashboard (WhatsApp verified users)
│   ├── dashboard.php
│   └── complaints.php
├── database/              # Database schema
│   └── schema.sql         # Includes branches, complaint_issues, otp_verifications
├── includes/              # Shared components
│   ├── header.php
│   └── footer.php
├── staff/                 # Staff dashboard
│   ├── dashboard.php
│   ├── complaints.php
│   └── assign.php
├── uploads/               # File uploads directory
├── contact.php
├── faq.php
├── index.php
├── profile.php            # Admin/Staff profile only
└── README.md
```

## Database Tables

- **branches**: Physical store locations (name, code, address)
- **departments**: Internal routing departments
- **users**: All users (customers identified by whatsapp_number)
- **otp_verifications**: OTP codes for WhatsApp verification
- **orders**: Customer orders (linked to branch)
- **complaint_issues**: Detailed issue list (replaces categories)
- **complaints**: Main complaints table (linked to branch, issue)
- **complaint_responses**: Conversation thread
- **complaint_attachments**: File uploads
- **activity_logs**: Audit trail

## Security Features

- WhatsApp OTP verification for customers
- Password hashing with bcrypt (admin/staff)
- Prepared statements for SQL queries
- XSS protection with output sanitization
- Session-based authentication
- Role-based access control
- Rate limiting on OTP requests

## WhatsApp Integration (Baileys)

This project uses the **Baileys** library for WhatsApp integration - a free, open-source solution.

### Setup
1. Navigate to `whatsapp-service` folder
2. Run `npm install`
3. Run `npm start`
4. Scan QR code with WhatsApp
5. Service is ready!

### API Endpoints
- `GET /health` - Check service status
- `GET /status` - Connection details
- `POST /send-otp` - Send OTP message
- `POST /send-message` - Send custom message
- `POST /logout` - Reset WhatsApp session

## License

This project is open source and available for educational and commercial use.
